/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.rei.category;

import com.google.common.collect.Lists;
import com.tacz.guns.compat.rei.display.GunSmithTableDisplay;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class GunSmithTableCategory
implements DisplayCategory<GunSmithTableDisplay> {
    private static final class_2561 TITLE = class_2561.method_43471((String)"block.tacz.gun_smith_table");
    private static final Renderer ICON = EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)ModItems.GUN_SMITH_TABLE.method_7854());

    public List<Widget> setupDisplay(GunSmithTableDisplay display, Rectangle bounds) {
        int x = bounds.x + 5;
        int y = bounds.y;
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        GunSmithTableRecipe recipe = display.getRecipe();
        EntryStack output = EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)recipe.getOutput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 3, y + 12)).entry(output).markOutput());
        List<GunSmithTableIngredient> inputs = recipe.getInputs();
        int size = inputs.size();
        if (size < 7) {
            for (int i = 0; i < size; ++i) {
                int xOffset = 35 + 20 * i;
                int yOffset = 12;
                widgets.add(Widgets.createSlot((Point)new Point(x + xOffset, y + yOffset)).entries(this.getInput(inputs, i)).markInput());
            }
        } else {
            int yOffset;
            int xOffset;
            int i;
            for (i = 0; i < 6; ++i) {
                xOffset = 35 + 20 * i;
                yOffset = 2;
                widgets.add(Widgets.createSlot((Point)new Point(x + xOffset, y + yOffset)).entries(this.getInput(inputs, i)).markInput());
            }
            for (i = 6; i < size; ++i) {
                xOffset = 35 + 20 * (i - 6);
                yOffset = 22;
                widgets.add(Widgets.createSlot((Point)new Point(x + xOffset, y + yOffset)).entries(this.getInput(inputs, i)).markInput());
            }
        }
        return widgets;
    }

    private List<EntryStack<class_1799>> getInput(List<GunSmithTableIngredient> inputs, int index) {
        if (index < inputs.size()) {
            GunSmithTableIngredient ingredient = inputs.get(index);
            class_1799[] items = ingredient.ingredient().method_8105();
            Arrays.stream(items).forEach(stack -> stack.method_7939(ingredient.count()));
            return Stream.of(items).map(stack -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)stack)).toList();
        }
        return Collections.singletonList(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)class_1799.field_8037));
    }

    public CategoryIdentifier<? extends GunSmithTableDisplay> getCategoryIdentifier() {
        return GunSmithTableDisplay.ID;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public Renderer getIcon() {
        return ICON;
    }

    public int getDisplayWidth(GunSmithTableDisplay display) {
        return 160;
    }

    public int getDisplayHeight() {
        return 40;
    }
}

